local mod = DBM:NewMod("Horsemen", "DBM-Naxx", 4)
local L = mod:GetLocalizedStrings()

mod:SetRevision(("$Revision: 599 $"):sub(12, -3))
mod:SetCreatureID(30549)
mod:SetZone()

mod:RegisterCombat("combat", 16063, 16064, 16065, 30549)

mod:EnableModel()

mod:RegisterEvents(
	"SPELL_CAST_SUCCESS",
	"SPELL_AURA_APPLIED_DOSE"
)

local warnMarkSoon			= mod:NewAnnounce("WarningMarkSoon", 1, 28835, false)
local warnMarkNow			= mod:NewAnnounce("WarningMarkNow", 2, 28835)
local specWarnMarkOnPlayer	= mod:NewSpecialWarning("SpecialWarningMarkOnPlayer", nil, false, true)

--local timerMark				= mod:NewTimer(8, "TimerMark", 28835)

mod:AddBoolOption("HealthFrame", true)

mod:SetBossHealthInfo(
	16064, L.Korthazz,
	30549, L.Rivendare,
	16065, L.Blaumeux,
	16063, L.Zeliek
)

local markCounter = 0

function mod:OnCombatStart(delay)
	markCounter = 0
--	timerMark:Start(15, markCounter + 1)
--	warnMarkSoon:Schedule(12, markCounter + 1)
end

local markSpam = 0
function mod:SPELL_CAST_SUCCESS(args)
	if (args.spellId == 28832
	or args.spellId == 28833
	or args.spellId == 28834
	or args.spellId == 28835) and (GetTime() - markSpam) > 5 then
		markSpam = GetTime()
		markCounter = markCounter + 1
--		warnMarkNow:Show(markCounter)
--		warnMarkSoon:Schedule(5, markCounter + 1)
--		timerMark:Start(tostring(markCounter + 1))
	end
end

function mod:SPELL_AURA_APPLIED_DOSE(args)
	if (args.spellId == 28832
	or args.spellId == 28833
	or args.spellId == 28834
	or args.spellId == 28835) and args.destName == UnitName("player") then
		if args.amount >= 4 then
			specWarnMarkOnPlayer:Show(args.spellName, args.amount)
		end
	end
end

