if (AzDropDown) and (AzDropDown.vers > 2) then
	return;
end

AzDropDown = { vers = 2 };

local menu;
local menuMaxItems = 15;
local menuItemHeight = 14;
local backDrop = { bgFile = "Interface\\ChatFrame\\ChatFrameBackground", edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = 1, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } };

--------------------------------------------------------------------------------------------------------
--                                          Menu Functions                                            --
--------------------------------------------------------------------------------------------------------

-- MenuItem OnClick
local function DropDownMenuItem_OnClick(self,button)
	local table = menu.list[self.index];
	menu.SelectValueFunc(menu.parent,table);
	if (menu.isDropDown) then
		menu.parent.label:SetText(table.text);
		menu.parent.SelectedValue = table.value;
	end
	menu:Hide();
end

-- Make Menu Item
local function DropDownMenu_MakeItem()
	local item = CreateFrame("Button",nil,menu);
	item:SetHeight(menuItemHeight);
	item:SetHitRectInsets(-12,-10,0,0);
	item:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight");
	item:SetScript("OnClick",DropDownMenuItem_OnClick);

	item.text = item:CreateFontString(nil,"ARTWORK","GameFontHighlightSmall");
	item.text:SetPoint("LEFT",2,0);

	item.check = item:CreateTexture(nil,"ARTWORK");
	item.check:SetTexture("Interface\\Buttons\\UI-CheckBox-Check");
	item.check:SetWidth(14);
	item.check:SetHeight(14);
	item.check:SetPoint("RIGHT",item,"LEFT");
	item.check:Hide();

	if (#menu.items == 0) then
		item:SetPoint("TOPLEFT",20,-8);
	else
		item:SetPoint("TOPLEFT",menu.items[#menu.items],"BOTTOMLEFT");
		item:SetPoint("TOPRIGHT",menu.items[#menu.items],"BOTTOMRIGHT");
	end

	tinsert(menu.items,item);
	return item;
end

-- UpdateList
local function DropDownMenu_UpdateList()
	FauxScrollFrame_Update(menu.scroll,#menu.list,menuMaxItems,menuItemHeight);
	local index, item, entry;
	-- Loop
	for i = 1, menuMaxItems do
		index = (FauxScrollFrame_GetOffset(menu.scroll) + i);
		item = menu.items[i] or DropDownMenu_MakeItem();
		if (index <= #menu.list) then
			entry = menu.list[index];
			item.text:SetText(entry.text);
			item.index = index;
			item.text:SetTextColor(1,entry.header and 0.82 or 1,entry.header and 0 or 1);
			if (entry.header) then
				item:Disable();
			else
				item:Enable();
			end
			if (menu.isDropDown and entry.value == menu.parent.SelectedValue) or (entry.checked) then
				item.check:Show();
			else
				item.check:Hide();
			end
			item:Show();
		else
			item:Hide();
		end
	end
end

-- Create Menu
local function CreateDropDownMenu()
	menu = CreateFrame("Frame",nil,nil);
	menu:SetBackdrop(backDrop);
	menu:SetBackdropColor(0.1,0.1,0.1,1);
	menu:SetBackdropBorderColor(0.4,0.4,0.4,1);
	menu:SetToplevel(1);
	menu:SetClampedToScreen(1);
	menu:SetFrameStrata("FULLSCREEN_DIALOG");
	menu:Hide();

	menu.text = menu:CreateFontString(nil,"ARTWORK","GameFontHighlightSmall");
	menu.text:Hide();

	menu.scroll = CreateFrame("ScrollFrame","AzDropDownScroll",menu,"FauxScrollFrameTemplate");
	menu.scroll:SetScript("OnVerticalScroll",function(self,offset) FauxScrollFrame_OnVerticalScroll(self,offset,menuItemHeight,DropDownMenu_UpdateList); end); -- Az: wotlk change

	menu.items = {};
	menu.list = {};
end

--------------------------------------------------------------------------------------------------------
--                                        Drop Down Functions                                         --
--------------------------------------------------------------------------------------------------------

-- InitList
local function InitDropDown(parent,initFunc,selectValueFunc,point,parentPoint)
	if (not initFunc) then
		return;
	end
	-- Set DropDown Parent
	menu.parent = parent;
	menu:SetParent(parent);
	-- Clear Old List & Init the New
	for n in next, menu.list do
		menu.list[n] = nil;
	end
	menu.SelectValueFunc = selectValueFunc;
	menu.InitFunc = initFunc;
	initFunc(parent,menu.list);
	DropDownMenu_UpdateList();
	-- Anchor to DropDown Parent, and Refit Scroll
	menu:ClearAllPoints();
	menu:SetPoint(point or "TOPRIGHT",parent,parentPoint or "BOTTOMRIGHT");
	menu.scroll:ClearAllPoints();
	menu.scroll:SetPoint("TOPLEFT",menu.items[1]);
	menu.scroll:SetPoint("BOTTOMRIGHT",menu.items[min(#menu.list,menuMaxItems)]);
	-- Set Width
	local maxItemWidth = 0;
	for _, table in ipairs(menu.list) do
		menu.text:SetText(table.text);
		maxItemWidth = max(maxItemWidth,menu.text:GetWidth() + 10);
	end
	if (#menu.list > menuMaxItems) then
		maxItemWidth = (maxItemWidth + 12);
		menu.items[1]:SetPoint("TOPRIGHT",-28,-8);
	else
		menu.items[1]:SetPoint("TOPRIGHT",-16,-8);
	end
	menu:SetWidth(maxItemWidth + 38);
	menu:SetHeight(min(#menu.list,menuMaxItems) * menuItemHeight + 16);
end

-- OnClick
local function DropDown_OnClick(self,button)
	if (not menu) then
		CreateDropDownMenu();
	end
	PlaySound("igMainMenuOptionCheckBoxOn");
	menu.isDropDown = 1;
	local parent = self:GetParent();
	if (menu:IsShown()) and (menu.parent == parent) then
		menu:Hide();
	else
		InitDropDown(parent,parent.InitFunc,parent.SelectValueFunc);
		menu:Show();
	end
end

--------------------------------------------------------------------------------------------------------
--                                        "Exported" Functions                                        --
--------------------------------------------------------------------------------------------------------

-- ToggleMenu
function AzDropDown.HideMenu(parent,initFunc,selectValueFunc)
	if (menu) then
		menu:Hide();
	end
end

-- ToggleMenu
function AzDropDown.ToggleMenu(parent,initFunc,selectValueFunc,point,parentPoint)
	if (not parent or not initFunc or not selectValueFunc) then
		return;
	end
	if (not menu) then
		CreateDropDownMenu();
	end
	PlaySound("igMainMenuOptionCheckBoxOn");
	menu.isDropDown = nil;
	if (menu:IsShown()) and (menu.parent == parent) then
		menu:Hide();
	else
		InitDropDown(parent,initFunc,selectValueFunc,point,parentPoint);
		menu:Show();
	end
end

-- Init Selected
function AzDropDown.InitSelectedItem(dropDown,selectedValue)
	if (not menu) then
		CreateDropDownMenu();
	end
	InitDropDown(dropDown,dropDown.InitFunc,dropDown.SelectValueFunc);
	if (selectedValue) then
		dropDown.SelectedValue = selectedValue;
	end
	for _, table in ipairs(menu.list) do
		if (table.value == dropDown.SelectedValue) then
			dropDown.label:SetText(table.text);
			return;
		end
	end
	dropDown.label:SetText("|cff00ff00Выберите значение...");
end

-- Create DropDown
function AzDropDown.CreateDropDown(parent,width,initFunc,selectValueFunc)
	if (not parent or not width or not initFunc or not selectValueFunc) then
		return;
	end
	local f = CreateFrame("Frame",nil,parent);
	f:SetWidth(width);
	f:SetHeight(24);
	f:SetBackdrop(backDrop);
	f:SetBackdropColor(0.1,0.1,0.1,1);
	f:SetBackdropBorderColor(0.4,0.4,0.4,1);

	f.button = CreateFrame("Button",nil,f);
	f.button:SetPoint("TOPRIGHT");
	f.button:SetPoint("BOTTOMRIGHT");
	f.button:SetWidth(24);
	f.button:SetHitRectInsets(-1 * (f:GetWidth() - f.button:GetWidth()),0,0,0);

	f.button:SetScript("OnClick",DropDown_OnClick);

	f.button:SetNormalTexture("Interface\\ChatFrame\\UI-ChatIcon-ScrollDown-Up");
	f.button:SetPushedTexture("Interface\\ChatFrame\\UI-ChatIcon-ScrollDown-Down");
	f.button:SetDisabledTexture("Interface\\ChatFrame\\UI-ChatIcon-ScrollDown-Disabled");
	f.button:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight");

	f.label = f:CreateFontString(nil,"ARTWORK","GameFontHighlightSmall");
	f.label:SetPoint("RIGHT",f.button,"LEFT",-2,0);

	f.InitFunc = initFunc;
	f.SelectValueFunc = selectValueFunc;
	return f;
end